#[ Game Level Reset ]#

#: reset undo tracker
data modify storage tt:data undo set value []
scoreboard players set move.count undo 0
scoreboard players set undo.id undo 1
scoreboard players reset @e[type=item_display,scores={undo=2..},tag=!player] undo

#: reset player position
ride @s[predicate=!tt:is_mounted] mount @n[type=text_display,distance=..3,tag=camera.player]

#: reset spectators
schedule clear tt:spectate
schedule function tt:spectate 2t
execute as @a[tag=spectator] run spectate

#: level name
execute store result storage tt:data level.num int 1 run scoreboard players get game.level game_variables
function tt:game/level/name with storage tt:data level

#: reset boxes
tag @e[tag=check.boxes] remove check.boxes
tag @e[tag=check.fail] remove check.fail
tag @e[tag=disabled] remove disabled
kill @e[tag=used.box]

#: summon pumpkin box
execute at @e[tag=object.spawner,tag=pumpkin_box] unless entity @n[tag=object,tag=pumpkin_box,distance=..1] run summon item_display ~ ~0.5 ~ {CustomName:'{"text":"Pumpkin Block","bold":true,"color":"#fb782d"}',teleport_duration:4,Rotation:[180F,90F],Tags:["new","object","pumpkin_box"],transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,-0.5f],scale:[1f,1f,1f]},item:{id:"minecraft:carved_pumpkin",count:1b,components:{custom_model_data:0}}}

#: summon honey
execute at @e[tag=object.spawner,tag=honey_box] unless entity @n[tag=object,tag=honey_box,distance=..1] run summon item_display ~ ~0.5 ~ {CustomName:'{"text":"Honey Block","bold":true,"color":"#f8a600"}',teleport_duration:4,Rotation:[180F,90F],Tags:["new","object","honey_box","honey_attached"],transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,-0.5f],scale:[1f,1f,1f]},item:{id:"minecraft:yellow_terracotta",count:1b,components:{custom_model_data:0}}}

#: summon purple box
execute at @e[tag=object.spawner,tag=purple_box] unless entity @n[tag=object,tag=purple_box,distance=..1] run summon item_display ~ ~0.5 ~ {CustomName:'{"text":"Purple Candy","bold":true,"color":"#a800a8"}',teleport_duration:4,Rotation:[180F,90F],Tags:["new","object","purple_box"],transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,-0.5f],scale:[1f,1f,1f]},item:{id:"minecraft:purple_dye",count:1b,components:{custom_model_data:0}}}

#: summon cyan box
execute at @e[tag=object.spawner,tag=cyan_box] unless entity @n[tag=object,tag=cyan_box,distance=..1] run summon item_display ~ ~0.5 ~ {CustomName:'{"text":"Cyan Candy","bold":true,"color":"#3a968a"}',teleport_duration:4,Rotation:[180F,90F],Tags:["new","object","cyan_box"],transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,-0.5f],scale:[1f,1f,1f]},item:{id:"minecraft:cyan_dye",count:1b,components:{custom_model_data:0}}}

#: summon orange box
execute at @e[tag=object.spawner,tag=orange_box] unless entity @n[tag=object,tag=orange_box,distance=..1] run summon item_display ~ ~0.5 ~ {CustomName:'{"text":"Candy Corn","bold":true,"color":"#fb700c"}',teleport_duration:4,Rotation:[180F,90F],Tags:["new","object","orange_box"],transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,-0.5f],scale:[1f,1f,1f]},item:{id:"minecraft:orange_dye",count:1b,components:{custom_model_data:0}}}

#: clear new tag
tag @e[tag=new,tag=object] remove new

#: player spawns
data merge entity @n[tag=player] {teleport_duration:0}
execute if score game.level game_variables matches 0 as @n[tag=player] at @n[tag=player.location,tag=level_00] run function tt:game/level/teleport
execute if score game.level game_variables matches 1 as @n[tag=player] at @n[tag=player.location,tag=level_01] run function tt:game/level/teleport
execute if score game.level game_variables matches 2 as @n[tag=player] at @n[tag=player.location,tag=level_02] run function tt:game/level/teleport
execute if score game.level game_variables matches 3 as @n[tag=player] at @n[tag=player.location,tag=level_03] run function tt:game/level/teleport
execute if score game.level game_variables matches 4 as @n[tag=player] at @n[tag=player.location,tag=level_04] run function tt:game/level/teleport
execute if score game.level game_variables matches 5 as @n[tag=player] at @n[tag=player.location,tag=level_05] run function tt:game/level/teleport
execute if score game.level game_variables matches 6 as @n[tag=player] at @n[tag=player.location,tag=level_06] run function tt:game/level/teleport
execute if score game.level game_variables matches 7 as @n[tag=player] at @n[tag=player.location,tag=level_07] run function tt:game/level/teleport
execute if score game.level game_variables matches 8 as @n[tag=player] at @n[tag=player.location,tag=level_08] run function tt:game/level/teleport
execute if score game.level game_variables matches 9 as @n[tag=player] at @n[tag=player.location,tag=level_09] run function tt:game/level/teleport
execute if score game.level game_variables matches 10 as @n[tag=player] at @n[tag=player.location,tag=level_10] run function tt:game/level/teleport
execute if score game.level game_variables matches 11 as @n[tag=player] at @n[tag=player.location,tag=level_11] run function tt:game/level/teleport
execute if score game.level game_variables matches 12 as @n[tag=player] at @n[tag=player.location,tag=level_12] run function tt:game/level/teleport
execute if score game.level game_variables matches 13 as @n[tag=player] at @n[tag=player.location,tag=level_13] run function tt:game/level/teleport
data merge entity @n[tag=player] {teleport_duration:4}
